/*
  Name: sunnydale.cpp
  Copyright: GPL
  Author: ALessandro Bugatti
  Date: 27/01/05 00.13
  Description: soluzione del problema Sunnydale della selezione regionale
  delle IOI 2005
*/


#include <cstdlib>
#include <iostream>
#include <fstream>

using namespace std;

int N; //numero di svincoli
int M; //numero di gallerie
int H; //svincolo di Harmony
int S; //svincolo di Spike

struct svincolo{
    int svincoloCollegato;
    int luce;
    svincolo():luce(0){};
};

//Ne metto 50001 cos posso evitare di modificare gli indici degli svincoli
//che partono da 1 e non da zero
svincolo svincoli[50001];

int main(int argc, char *argv[])
{
    fstream in,out;
    in.open("input.txt",ios::in);
    if (in.fail()) exit(1);
    out.open("output.txt",ios::out);
    if (out.fail()) exit(1);
    in >> N >> M >> H >> S;
    
    for (int i=1;i<=M;i++)
    {
        int A, B, L;
        in >> A >> B >> L;
        if (svincoli[A].luce == 0 || svincoli[A].luce>L)
            {
                svincoli[A].luce = L;
                svincoli[A].svincoloCollegato = B;
            }
        if (svincoli[B].luce == 0 || svincoli[B].luce>L)
        {
            svincoli[B].luce = L;
            svincoli[B].svincoloCollegato = A;
        }
   }
   int arrivo= H;
   int gallerie=0;
   do
   {
        gallerie++;
        arrivo = svincoli[arrivo].svincoloCollegato;
    }while(arrivo != S && arrivo !=H);
    if (arrivo == H)
        out << "-1" << endl;
    else
        out << gallerie << endl;    
    
    in.close();
    out.close();
    return EXIT_SUCCESS;
}
