/*Soluzione Elio*/
/* Greedy  n log n  (con priority queue)*/

#include <fstream>
#include <iostream>
#include <queue>

using namespace std;

struct Missione { 
  int durata, scadenza;
};

bool operator<(const Missione m1, const Missione m2) {
	return m1.durata < m2.durata;
}

int n;

priority_queue<Missione> Q;

int main() {
	ifstream fin("input.txt");
	ofstream fout("output.txt");
	fin >> n;
	Missione missioni[n];
	for (int i=0; i < n; i++)
		fin >> missioni[i].durata >> missioni[i].scadenza;
		
	int numMissioni = 1;	
	int fine = missioni[0].durata;
	Q.push(missioni[0]);

	for(int i = 1; i < n; i++) {
		Missione miss = missioni[i];
		numMissioni++;
		fine += miss.durata;
		Q.push(miss)	;
		if(fine > miss.scadenza) {
			Missione daElim = Q.top();
			Q.pop();
			fine -= daElim.durata;
			numMissioni--;
		}	
	}
	
	cout << numMissioni << endl;
	fout << numMissioni;
	while(!Q.empty()) {
		cout << Q.top().durata << " " << Q.top().scadenza << endl;
		Q.pop();
	}
	
}
 
