#include <stdio.h>
#include <stdlib.h>

/***
  strutture dati
***/

/* 
   albero
*/
int albero[20][20] = {  
//   A    B    C    D    E    F    G    H    I    J    K    L    M    N    O    P    Q    R    S    T
  {  0,  71,   0,   0,   0,   0,   0, 151,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}, // A
  { 71,   0,  75,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}, // B
  {  0,  75,   0, 118,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}, // C
  {  0,   0, 118,   0, 111,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}, // D
  {  0,   0,   0, 111,   0,  70,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}, // E
  {  0,   0,   0,   0,  70,   0,  75,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}, // F
  {  0,   0,   0,   0,   0,  75,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}, // G
  {151,   0,   0,   0,   0,   0,   0,   0,  99,  80,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}, // H
  {  0,   0,   0,   0,   0,   0,   0,  99,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}, // I
  {  0,   0,   0,   0,   0,   0,   0,  80,   0,   0, 146,   0,   0,   0,   0,   0,   0,   0,   0,   0}, // J
  {  0,   0,   0,   0,   0,   0,   0,   0,   0, 146,   0, 138,   0,   0,   0,   0,   0,   0,   0,   0}, // K
  {  0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 138,   0, 101,   0,   0,   0,   0,   0,   0,   0}, // L
  {  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 101,   0,  90,  85,   0,   0,   0,   0,   0}, // M
  {  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,  90,   0,   0,   0,   0,   0,   0,   0}, // N
  {  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,  85,   0,   0,  98, 142,   0,   0,   0}, // O
  {  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,  98,   0,  86,   0,   0,   0}, // P
  {  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,  86,   0,   0,   0,   0}, // Q
  {  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 142,   0,   0,   0,  92,   0}, // R
  {  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,  92,   0,  87}, // S
  {  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,  87,   0}  // T
};

/* 
   coda espl

   un vertice e' rappresentato da un int:
   A -> 0
   B -> 1
   ...
   T -> 19
*/
int espl[20];

/* 
   distanze
*/
int dist[20] = {-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1}; // -1 al posto di "infinito"



/***
  algoritmo
***/
int main(int argc, char *argv[]) {
  int x,y;
  int primo, ultimo;
  int u,v;
  int i,j;
  int solincoda=0;

  /* vertici x e y da linea di comando */
  if (argc<3) {
    printf("servono due vertici\n");
    exit(1);
  }
  
  x = argv[1][0];
  x = x-'A';
  if (x<0 || x>19) {
    printf("primo argomento deve essere tra A e T\n");
    exit(1);
  } else
    printf("primo vertice %c\n", x+'A');

  y = argv[2][0];
  y = y-'A';
  if (y<0 || y>19) {
    printf("secondo argomento deve essere tra A e T\n");
    exit(1);
  } else
    printf("secondo vertice %c\n", y+'A');

  // primo e ultimo nella coda
  primo = 0;
  ultimo = 0;

  // setta dist(x) e inserisce x in coda
  dist[x] = 0;
  espl[0] = x;
  ultimo++;

  u = espl[primo]; // prossimo vertice da coda
  printf("%c\n", 'A'+u);

  while (u!=y && !solincoda) { // se e' y termina
    // rimuove u da coda
    espl[primo] = -1;
    primo++;

    for (v=0; v<20; v++) {
      if (albero[u][v]>0 && dist[v]==-1) { // vertici v vicini ad u da considerare
	// setta dist(v) e inserisce v in coda
	dist[v] = dist[u] + albero[u][v];
	espl[ultimo] = v;
	ultimo++;
	if (v==y) solincoda=1;
      }
    }

    u = espl[primo]; // prossimo vertice da coda
    printf("%c\n", 'A'+u);
  }

  printf("distanza: %d\n", dist[y]);

  exit(0);
}
