#include <stdio.h>
#include <stdlib.h>

#include "funzioni.h"

typedef struct {
  int x;
  int y;
  int val[3][3]; 
} stato;

int _uguali(stato st1, stato st2);
int _stima(stato st);

stato stati[100];
stato sti = {2,2,{{1,2,3},{7,4,6},{5,8,0}}};
stato stf = {2,2,{{1,2,3},{4,5,6},{7,8,0}}};
int distanze[20];
int espl[20];
int primo = 0;
int ultimo = 0;
int nstati = 0;

int partenza(int argc, char *argv[]) {
  int s;

  stati[0] = sti;
  nstati++;

  s=0;
  printf("primo stato:\n");
  stampa(s);

  return s;
}

int arrivo(int argc, char *argv[]) {
  int s;

  stati[1] = stf;
  nstati++;

  s=1;
  printf("ultimo stato:\n");
  stampa(s);

  return s;
}

int finito(int s, int f, int solincoda) {
  if (s == f)
    return 1;
  else
    return 0;
}

int lung(int s1, int s2) {
  return 1;
}

void vicini(int vic[], int s) {
  int dx,dy;
  int i,j,k;
  stato st=stati[s],stv;

  k=0;
  for (i=0; i<4; i++) {
    dx=0;
    dy=0;
    if (i==0) dx=-1;
    if (i==1) dx=1;
    if (i==2) dy=-1;
    if (i==3) dy=1;

    if (st.x + dx < 0 || st.x + dx > 2)
      continue;
    if (st.y + dy < 0 || st.y + dy > 2)
      continue;

    stv = st;
    stv.x = st.x + dx;
    stv.y = st.y + dy;
    stv.val[st.y][st.x] = stv.val[stv.y][stv.x];
    stv.val[stv.y][stv.x]=0;

    for (j=0; j<nstati; j++) {
      if (_uguali(stv, stati[j])) {
	break;
      }
    }
    if (j==nstati || distanze[j] > distanze[s]+1) {
      stati[nstati] = stv;
      vic[k] = nstati;
      nstati++;
      k++;
    }
    if (j==1) { // stato finale
      vic[k] = 1;
      k++;
    }
  }
  vic[k] = -1;

  return;
}

void settadist(int s, int val) {
  distanze[s] = val;

  return;
}

int dist(int s) {
  return distanze[s];
}

void inserisci(int s) {
  int i,j;
  int h1,h2;

  if (primo==ultimo) { // coda vuota
    espl[primo]=s;
    ultimo++;
  } else {
    // se s e' in coda lo rimuovo
    for (i=primo; i<ultimo; i++) {
      if (espl[i]==s) {
	break;
      }
    }
    if (i<ultimo) {
      ultimo--;
      for (; i<ultimo; i++) {
	espl[i] = espl[i+1];
      }
    }

    for (i=primo; i<ultimo; i++) {
      h1 = _stima(stati[espl[i]]);
      h2 = _stima(stati[s]);
      if (distanze[espl[i]]+h1 > distanze[s]+h2)
	break;
    }
    ultimo++;
    for (j=ultimo; j>i; j--)
      espl[j] = espl[j-1];
    
    espl[i] = s;
  }

  return;
}

int leggiprimo() {
  return espl[primo];
}

void rimuoviprimo() {
  espl[primo] = -1;
  primo++;

  return;
}

void stampa(int s) {
  int i,j;

  for (i=0; i<3; i++) {
    for (j=0; j<3; j++) {
      if (stati[s].val[i][j]==0)
	printf(" ");
      else
	printf("%d", stati[s].val[i][j]);
    }
    printf("\n");
  }
  printf("\n");

  return;
}

int _uguali(stato st1, stato st2) {
  int i,j;
  int rv=1;

  for (i=0; i<3; i++) {
    for (j=0; j<3; j++) {
      if (st1.val[i][j]!=st2.val[i][j]) {
	rv=0;
	break;
      }
    }
    if (j!=3) break;
  }

  return rv;
}

int _stima(stato st) {
  int i,j,k,l;
  int dx,dy;
  int rv=1;
  int h=0;

  for (i=0; i<3; i++) {
    for (j=0; j<3; j++) {
      for (k=0; k<3; k++) {
	for (l=0; l<3; l++) {
	  if (st.val[i][j]==stf.val[k][l]) {
	    dy = abs(i-k);
	    dx = abs(j-l);
	    break;
	  }
	}
	if (l<3) break;
      }
      h = h+dx+dy;
    }
  }

  return h;
}
